<?php
/**
 * Invoice List page template
 *
 * @package EDM_Efatura_Premium
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get database instance
$db = new EDM_Efatura_Premium_DB();

// Set default filter values
$page = isset($_GET['paged']) ? max(1, intval($_GET['paged'])) : 1;
$per_page = isset($_GET['per_page']) ? max(10, intval($_GET['per_page'])) : 20;
$filters = array(
    'direction' => isset($_GET['direction']) ? sanitize_text_field($_GET['direction']) : '',
    'status' => isset($_GET['status']) ? sanitize_text_field($_GET['status']) : '',
    'customer_name' => isset($_GET['customer_name']) ? sanitize_text_field($_GET['customer_name']) : '', // Changed from customer_vkn to customer_name
    'start_date' => isset($_GET['start_date']) ? sanitize_text_field($_GET['start_date']) : date('Y-m-d', strtotime('-30 days')),
    'end_date' => isset($_GET['end_date']) ? sanitize_text_field($_GET['end_date']) : date('Y-m-d')
);

// We'll only use the database for listing with proper pagination
$result = $db->get_invoices($page, $per_page, $filters);
$invoices = $result['invoices'];
$total = $result['total'];
$total_pages = $result['pages'];
?>

<div class="wrap">
    <h1 class="wp-heading-inline"><?php echo esc_html__('Invoice List', 'edm-efatura-premium'); ?></h1>
    
    <hr class="wp-header-end">
    
    <div class="edm-invoice-filters">
        <form method="get" id="edm-invoice-filter-form">
            <input type="hidden" name="page" value="edm-efatura-premium-list" />
            
            <div class="form-row">
                <label for="direction"><?php esc_html_e('Direction', 'edm-efatura-premium'); ?></label>
                <select id="direction" name="direction">
                    <option value=""><?php esc_html_e('All', 'edm-efatura-premium'); ?></option>
                    <option value="IN" <?php selected($filters['direction'], 'IN'); ?>><?php esc_html_e('Incoming', 'edm-efatura-premium'); ?></option>
                    <option value="OUT" <?php selected($filters['direction'], 'OUT'); ?>><?php esc_html_e('Outgoing', 'edm-efatura-premium'); ?></option>
                    <option value="OUT-EINVOICE" <?php selected($filters['direction'], 'OUT-EINVOICE'); ?>><?php esc_html_e('Outgoing (E-Invoice)', 'edm-efatura-premium'); ?></option>
                    <option value="OUT-EARCHIVE" <?php selected($filters['direction'], 'OUT-EARCHIVE'); ?>><?php esc_html_e('Outgoing (E-Archive)', 'edm-efatura-premium'); ?></option>
                </select>
            </div>
            
            <div class="form-row">
                <label for="status"><?php esc_html_e('Status', 'edm-efatura-premium'); ?></label>
                <select id="status" name="status">
                    <option value=""><?php esc_html_e('All', 'edm-efatura-premium'); ?></option>
                    <option value="DRAFT" <?php selected($filters['status'], 'DRAFT'); ?>><?php esc_html_e('Draft', 'edm-efatura-premium'); ?></option>
                    <option value="PROCESSING" <?php selected($filters['status'], 'PROCESSING'); ?>><?php esc_html_e('Processing', 'edm-efatura-premium'); ?></option>
                    <option value="APPROVED" <?php selected($filters['status'], 'APPROVED'); ?>><?php esc_html_e('Approved', 'edm-efatura-premium'); ?></option>
                    <option value="DECLINED" <?php selected($filters['status'], 'DECLINED'); ?>><?php esc_html_e('Declined', 'edm-efatura-premium'); ?></option>
                    <option value="CANCELLED" <?php selected($filters['status'], 'CANCELLED'); ?>><?php esc_html_e('Cancelled', 'edm-efatura-premium'); ?></option>
                </select>
            </div>
            
            <div class="form-row">
                <label for="start_date"><?php esc_html_e('Start Date', 'edm-efatura-premium'); ?></label>
                <input type="date" id="start_date" name="start_date" value="<?php echo esc_attr($filters['start_date']); ?>" class="edm-date-range-picker" />
            </div>
            
            <div class="form-row">
                <label for="end_date"><?php esc_html_e('End Date', 'edm-efatura-premium'); ?></label>
                <input type="date" id="end_date" name="end_date" value="<?php echo esc_attr($filters['end_date']); ?>" class="edm-date-range-picker" />
            </div>
            
            <div class="form-row">
                <label for="customer_name"><?php esc_html_e('Customer Name', 'edm-efatura-premium'); ?></label>
                <input type="text" id="customer_name" name="customer_name" value="<?php echo esc_attr($filters['customer_name']); ?>" placeholder="<?php esc_attr_e('Search by customer name', 'edm-efatura-premium'); ?>" />
            </div>
            
            <div class="form-row">
                <label for="per_page"><?php esc_html_e('Per Page', 'edm-efatura-premium'); ?></label>
                <select id="per_page" name="per_page">
                    <option value="10" <?php selected($per_page, 10); ?>>10</option>
                    <option value="20" <?php selected($per_page, 20); ?>>20</option>
                    <option value="50" <?php selected($per_page, 50); ?>>50</option>
                    <option value="100" <?php selected($per_page, 100); ?>>100</option>
                </select>
            </div>
            
            <div class="form-row">
                <button type="submit" class="button button-primary"><?php esc_html_e('Filter', 'edm-efatura-premium'); ?></button>
                <a href="<?php echo esc_url(admin_url('admin.php?page=edm-efatura-premium-list')); ?>" class="button"><?php esc_html_e('Reset', 'edm-efatura-premium'); ?></a>
            </div>
        </form>
    </div>
    
    <div class="edm-result-box" style="display: none;"></div>
    
    <div class="edm-invoice-list">
        <?php if (empty($invoices)) : ?>
            <div class="notice notice-info">
                <p><?php esc_html_e('No invoices found matching your criteria.', 'edm-efatura-premium'); ?></p>
            </div>
        <?php else : ?>
            <table class="wp-list-table widefat fixed striped edm-invoice-table">
                <thead>
                    <tr>
                        <th scope="col"><?php esc_html_e('Invoice ID', 'edm-efatura-premium'); ?></th>
                        <th scope="col"><?php esc_html_e('UUID', 'edm-efatura-premium'); ?></th>
                        <th scope="col"><?php esc_html_e('Date', 'edm-efatura-premium'); ?></th>
                        <th scope="col"><?php esc_html_e('Customer', 'edm-efatura-premium'); ?></th>
                        <th scope="col"><?php esc_html_e('Order ID', 'edm-efatura-premium'); ?></th>
                        <th scope="col"><?php esc_html_e('Amount', 'edm-efatura-premium'); ?></th>
                        <th scope="col"><?php esc_html_e('Status', 'edm-efatura-premium'); ?></th>
                        <th scope="col"><?php esc_html_e('Actions', 'edm-efatura-premium'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($invoices as $invoice) : 
                        $status_class = 'edm-status-' . strtolower($invoice['status'] ?? 'unknown');
                        $creation_date = !empty($invoice['creation_date']) ? $invoice['creation_date'] : (!empty($invoice['created_at']) ? $invoice['created_at'] : date('Y-m-d H:i:s'));
                        
                        // Check if this is from EDM Panel (no order_id)
                        $is_edm_panel = empty($invoice['order_id']);
                        
                        // Generate PDF download URL if available
                        $pdf_url = '';
                        if (!empty($invoice['pdf_path']) && file_exists($invoice['pdf_path'])) {
                            $pdf_url = add_query_arg(array(
                                'edm_invoice_download' => $invoice['uuid'],
                                'nonce' => wp_create_nonce('edm_invoice_download_' . $invoice['uuid'])
                            ), admin_url('admin.php?page=edm-efatura-premium-list'));
                        }
                    ?>
                        <tr>
                            <td>
                                <?php 
                                // Display invoice_id or id if invoice_id is not available
                                echo esc_html(!empty($invoice['invoice_id']) ? $invoice['invoice_id'] : (!empty($invoice['id']) ? $invoice['id'] : 'N/A')); 
                                ?>
                            </td>
                            <td>
                                <span title="<?php echo esc_attr($invoice['uuid'] ?? ''); ?>">
                                    <?php 
                                    $uuid = $invoice['uuid'] ?? '';
                                    if (strlen($uuid) > 16) {
                                        echo esc_html(substr($uuid, 0, 8) . '...' . substr($uuid, -8));
                                    } else {
                                        echo esc_html($uuid);
                                    }
                                    ?>
                                </span>
                            </td>
                            <td><?php echo esc_html(date_i18n(get_option('date_format'), strtotime($creation_date))); ?></td>
                            <td>
                                <?php 
                                $customer = !empty($invoice['customer_name']) ? $invoice['customer_name'] : 
                                            (!empty($invoice['customer']) ? $invoice['customer'] : 'N/A');
                                echo esc_html($customer);
                                if (!empty($invoice['customer_vkn'])) {
                                    echo ' (' . esc_html($invoice['customer_vkn']) . ')';
                                } else if (!empty($invoice['receiver'])) {
                                    echo ' (' . esc_html($invoice['receiver']) . ')';
                                }
                                ?>
                            </td>
                            <td>
                                <?php if (!empty($invoice['order_id'])) : ?>
                                    <a href="<?php echo esc_url(admin_url('post.php?post=' . $invoice['order_id'] . '&action=edit')); ?>" target="_blank">
                                        #<?php echo esc_html($invoice['order_id']); ?>
                                    </a>
                                <?php else : ?>
                                    <span title="<?php esc_attr_e('This invoice was created in EDM Panel', 'edm-efatura-premium'); ?>">
                                        <?php esc_html_e('EDM Panel', 'edm-efatura-premium'); ?>
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php
                                $amount = !empty($invoice['amount']) ? $invoice['amount'] : 0;
                                $currency = !empty($invoice['currency']) ? $invoice['currency'] : 'TRY';
                                echo esc_html(number_format($amount, 2) . ' ' . $currency); 
                                ?>
                            </td>
                            <td><span class="edm-status <?php echo esc_attr($status_class); ?>"><?php echo esc_html($invoice['status'] ?? 'Unknown'); ?></span></td>
                            <td class="edm-invoice-actions">
                                <button type="button" class="button-link edm-check-status" data-uuid="<?php echo esc_attr($invoice['uuid'] ?? ''); ?>"><?php esc_html_e('Check Status', 'edm-efatura-premium'); ?></button>
                                
                                <?php 
                                $status = $invoice['status'] ?? ''; 
                                ?>
                                
                                <?php if (in_array($status, array('DRAFT', 'PROCESSING'))) : ?>
                                    <span class="sep">|</span>
                                    <button type="button" class="button-link edm-cancel-invoice" data-uuid="<?php echo esc_attr($invoice['uuid'] ?? ''); ?>"><?php esc_html_e('Cancel', 'edm-efatura-premium'); ?></button>
                                <?php endif; ?>
                                
                                <?php 
                                // PDF actions - only show if this is an invoice from our plugin (has order_id)
                                if (!$is_edm_panel) : 
                                ?>
                                    <?php if (!empty($pdf_url)) : ?>
                                        <span class="sep">|</span>
                                        <a href="<?php echo esc_url($pdf_url); ?>" class="button-link" target="_blank"><?php esc_html_e('Download PDF', 'edm-efatura-premium'); ?></a>
                                    <?php else : ?>
                                        <span class="sep">|</span>
                                        <button type="button" class="button-link edm-generate-pdf" data-uuid="<?php echo esc_attr($invoice['uuid'] ?? ''); ?>"><?php esc_html_e('Generate PDF', 'edm-efatura-premium'); ?></button>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            
            <?php if ($total_pages > 1) : ?>
                <div class="tablenav bottom">
                    <div class="tablenav-pages">
                        <span class="displaying-num">
                            <?php 
                            printf(
                                /* translators: %s: number of invoices */
                                _n('%s invoice', '%s invoices', $total, 'edm-efatura-premium'),
                                number_format_i18n($total)
                            ); 
                            ?>
                        </span>
                        
                        <span class="pagination-links">
                            <?php
                            echo paginate_links(array(
                                'base' => add_query_arg('paged', '%#%'),
                                'format' => '',
                                'prev_text' => '&laquo;',
                                'next_text' => '&raquo;',
                                'total' => $total_pages,
                                'current' => $page,
                                'add_args' => array(
                                    'direction' => $filters['direction'],
                                    'status' => $filters['status'],
                                    'customer_name' => $filters['customer_name'],
                                    'start_date' => $filters['start_date'],
                                    'end_date' => $filters['end_date'],
                                    'per_page' => $per_page
                                )
                            ));
                            ?>
                        </span>
                    </div>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
<script>
jQuery(document).ready(function($) {
    // edmEfaturaParams nonce değerini tanımlayalım
    window.edmEfaturaParams = window.edmEfaturaParams || {};
    window.edmEfaturaParams.nonce = '<?php echo wp_create_nonce('edm_efatura_premium_nonce'); ?>';
    
    // Check Status butonu
    $('.edm-check-status').on('click', function() {
        var uuid = $(this).data('uuid');
        var button = $(this);
        var $resultBox = $('.edm-result-box');
        
        button.prop('disabled', true).text('<?php _e('Checking...', 'edm-efatura-premium'); ?>');
        $resultBox.html('<p><span class="spinner is-active"></span> <?php _e('Checking invoice status...', 'edm-efatura-premium'); ?></p>').show();
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'edm_check_invoice_status',
                nonce: window.edmEfaturaParams.nonce,
                uuid: uuid
            },
            success: function(response) {
                button.prop('disabled', false).text('<?php _e('Check Status', 'edm-efatura-premium'); ?>');
                
                if (response.success) {
                    $resultBox.html('<div class="notice notice-success is-dismissible"><p><?php _e('Status checked successfully. Status: ', 'edm-efatura-premium'); ?>' + response.data.status + ' - ' + response.data.description + '</p></div>');
                    
                    // Add dismiss button functionality
                    $resultBox.find('.notice').append('<button type="button" class="notice-dismiss"><span class="screen-reader-text"><?php _e('Dismiss this notice.', 'edm-efatura-premium'); ?></span></button>');
                    
                    // Refresh page after 2 seconds
                    setTimeout(function() {
                        location.reload();
                    }, 500);
                } else {
                    $resultBox.html('<div class="notice notice-error is-dismissible"><p><?php _e('Error checking status:', 'edm-efatura-premium'); ?> ' + response.data + '</p></div>');
                    
                    // Add dismiss button functionality
                    $resultBox.find('.notice').append('<button type="button" class="notice-dismiss"><span class="screen-reader-text"><?php _e('Dismiss this notice.', 'edm-efatura-premium'); ?></span></button>');
                }
            },
            error: function(xhr, status, error) {
                button.prop('disabled', false).text('<?php _e('Check Status', 'edm-efatura-premium'); ?>');
                $resultBox.html('<div class="notice notice-error is-dismissible"><p><?php _e('An error occurred. Please try again.', 'edm-efatura-premium'); ?></p></div>');
                
                // Add dismiss button functionality
                $resultBox.find('.notice').append('<button type="button" class="notice-dismiss"><span class="screen-reader-text"><?php _e('Dismiss this notice.', 'edm-efatura-premium'); ?></span></button>');
            }
        });
    });
    
    // Generate PDF butonu
    $('.edm-generate-pdf').on('click', function() {
        var uuid = $(this).data('uuid');
        var button = $(this);
        var resultContainer = button.closest('tr').find('.edm-generate-result');
        
        if (!resultContainer.length) {
            resultContainer = $('<div class="edm-generate-result" style="margin-top:5px;"></div>');
            button.after(resultContainer);
        }
        
        button.prop('disabled', true).text(edmEfaturaParams.messages.generating);
        resultContainer.html('<p><span class="spinner is-active"></span> ' + edmEfaturaParams.messages.generating + '</p>').show();
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'edm_generate_pdf',
                nonce: edmEfaturaParams.nonce,
                uuid: uuid
            },
            success: function(response) {
                button.prop('disabled', false).text(edmEfaturaParams.messages.generate);
                
                if (response.success) {
                    resultContainer.html('<div class="notice notice-success is-dismissible"><p>' + response.data + '</p></div>');
                    
                    // Add dismiss button functionality
                    resultContainer.find('.notice').append('<button type="button" class="notice-dismiss"><span class="screen-reader-text">' + edmEfaturaParams.messages.dismiss + '</span></button>');
                    
                    // Refresh page after 2 seconds
                    setTimeout(function() {
                        location.reload();
                    }, 500);
                } else {
                    resultContainer.html('<div class="notice notice-error is-dismissible"><p>' + edmEfaturaParams.messages.error + ': ' + response.data + '</p></div>');
                    
                    // Add dismiss button functionality
                    resultContainer.find('.notice').append('<button type="button" class="notice-dismiss"><span class="screen-reader-text">' + edmEfaturaParams.messages.dismiss + '</span></button>');
                }
            },
            error: function(xhr, status, error) {
                button.prop('disabled', false).text(edmEfaturaParams.messages.generate);
                resultContainer.html('<div class="notice notice-error is-dismissible"><p>' + edmEfaturaParams.messages.error + ': ' + error + '</p></div>');
                
                // Add dismiss button functionality
                resultContainer.find('.notice').append('<button type="button" class="notice-dismiss"><span class="screen-reader-text">' + edmEfaturaParams.messages.dismiss + '</span></button>');
            }
        });
    });
    
    // Notice dismiss button handler
    $(document).on('click', '.notice-dismiss', function() {
        $(this).closest('.notice').fadeOut();
    });

    
    // Generate Invoice butonu - Direkt global ayarları kullanacak şekilde düzenlenmiş
    $('.edm-generate-invoice-list').on('click', function() {
        if (!confirm('<?php _e('Are you sure you want to generate an invoice for this order?', 'edm-efatura-premium'); ?>')) {
            return;
        }
        
        var orderId = $(this).data('order-id');
        var button = $(this);
        var resultContainer = $('.edm-generate-result[data-order="' + orderId + '"]');
        
        button.prop('disabled', true).text('<?php _e('Generating...', 'edm-efatura-premium'); ?>');
        resultContainer.html('<p><span class="spinner is-active"></span> <?php _e('Generating invoice...', 'edm-efatura-premium'); ?></p>').show();
        
        // Global ayarları kullanarak fatura oluştur
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'edm_generate_invoice_for_order',
                nonce: window.edmEfaturaParams.nonce,
                order_id: orderId
                // Profile, type_code ve exception_code gönderilmiyor - global ayarlar kullanılacak
            },
            success: function(response) {
                button.prop('disabled', false).text('<?php _e('Generate Invoice', 'edm-efatura-premium'); ?>');
                
                if (response.success) {
                    resultContainer.html('<div class="notice notice-success is-dismissible"><p>' + response.data + '</p></div>');
                    
                    // Add dismiss button functionality
                    resultContainer.find('.notice').append('<button type="button" class="notice-dismiss"><span class="screen-reader-text"><?php _e('Dismiss this notice.', 'edm-efatura-premium'); ?></span></button>');
                    
                    // Refresh page after 2 seconds
                    setTimeout(function() {
                        location.reload();
                    }, 500);
                } else {
                    resultContainer.html('<div class="notice notice-error is-dismissible"><p><?php _e('Error generating invoice:', 'edm-efatura-premium'); ?> ' + response.data + '</p></div>');
                    
                    // Add dismiss button functionality
                    resultContainer.find('.notice').append('<button type="button" class="notice-dismiss"><span class="screen-reader-text"><?php _e('Dismiss this notice.', 'edm-efatura-premium'); ?></span></button>');
                }
            },
            error: function(xhr, status, error) {
                button.prop('disabled', false).text('<?php _e('Generate Invoice', 'edm-efatura-premium'); ?>');
                resultContainer.html('<div class="notice notice-error is-dismissible"><p><?php _e('An error occurred. Please try again.', 'edm-efatura-premium'); ?></p></div>');
                
                // Add dismiss button functionality
                resultContainer.find('.notice').append('<button type="button" class="notice-dismiss"><span class="screen-reader-text"><?php _e('Dismiss this notice.', 'edm-efatura-premium'); ?></span></button>');
            }
        });
    });
    
    // Cancel Invoice butonu
    $('.edm-cancel-invoice').on('click', function() {
        if (!confirm('<?php _e('Are you sure you want to cancel this invoice?', 'edm-efatura-premium'); ?>')) {
            return;
        }
        
        var uuid = $(this).data('uuid');
        var button = $(this);
        var $resultBox = $('.edm-result-box');
        
        button.prop('disabled', true).text('<?php _e('Cancelling...', 'edm-efatura-premium'); ?>');
        $resultBox.html('<p><span class="spinner is-active"></span> <?php _e('Cancelling invoice...', 'edm-efatura-premium'); ?></p>').show();
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'edm_cancel_invoice',
                nonce: window.edmEfaturaParams.nonce,
                uuid: uuid
            },
            success: function(response) {
                button.prop('disabled', false).text('<?php _e('Cancel Invoice', 'edm-efatura-premium'); ?>');
                
                if (response.success) {
                    $resultBox.html('<div class="notice notice-success is-dismissible"><p>' + response.data + '</p></div>');
                    
                    // Add dismiss button functionality
                    $resultBox.find('.notice').append('<button type="button" class="notice-dismiss"><span class="screen-reader-text"><?php _e('Dismiss this notice.', 'edm-efatura-premium'); ?></span></button>');
                    
                    // Refresh page after 2 seconds
                    setTimeout(function() {
                        location.reload();
                    }, 500);
                } else {
                    $resultBox.html('<div class="notice notice-error is-dismissible"><p><?php _e('Error cancelling invoice:', 'edm-efatura-premium'); ?> ' + response.data + '</p></div>');
                    
                    // Add dismiss button functionality
                    $resultBox.find('.notice').append('<button type="button" class="notice-dismiss"><span class="screen-reader-text"><?php _e('Dismiss this notice.', 'edm-efatura-premium'); ?></span></button>');
                }
            },
            error: function(xhr, status, error) {
                button.prop('disabled', false).text('<?php _e('Cancel Invoice', 'edm-efatura-premium'); ?>');
                $resultBox.html('<div class="notice notice-error is-dismissible"><p><?php _e('An error occurred. Please try again.', 'edm-efatura-premium'); ?></p></div>');
                
                // Add dismiss button functionality
                $resultBox.find('.notice').append('<button type="button" class="notice-dismiss"><span class="screen-reader-text"><?php _e('Dismiss this notice.', 'edm-efatura-premium'); ?></span></button>');
            }
        });
    });
    
    // Notice dismiss button handler
    $(document).on('click', '.notice-dismiss', function() {
        $(this).closest('.notice').fadeOut();
    });
});
</script>
</div>