<?php
/**
 * EDM E-Fatura Premium Updates Page Template
 */
if (!defined('ABSPATH')) {
    exit;
}

$stats = $this->get_update_stats();
$is_dismissed = $dismissed_until && time() < $dismissed_until;
?>

<div class="wrap">
    <h1><?php _e('EDM E-Fatura Premium - Plugin Updates', 'edm-efatura-premium'); ?></h1>
    
    <div class="edm-updates-wrap">
        
        <!-- Update Statistics -->
        <div class="edm-stats-grid">
            <div class="edm-stat-box">
                <div class="edm-stat-number"><?php echo esc_html($stats['current_version']); ?></div>
                <div class="edm-stat-label"><?php _e('Current Version', 'edm-efatura-premium'); ?></div>
            </div>
            
            <div class="edm-stat-box">
                <div class="edm-stat-number">
                    <?php 
                    if ($stats['last_check']) {
                        echo esc_html(human_time_diff($stats['last_check'])) . ' ' . __('ago', 'edm-efatura-premium');
                    } else {
                        _e('Never', 'edm-efatura-premium');
                    }
                    ?>
                </div>
                <div class="edm-stat-label"><?php _e('Last Check', 'edm-efatura-premium'); ?></div>
            </div>
            
            <div class="edm-stat-box">
                <div class="edm-stat-number"><?php echo esc_html($stats['check_interval']); ?></div>
                <div class="edm-stat-label"><?php _e('Check Interval', 'edm-efatura-premium'); ?></div>
            </div>
            
            <div class="edm-stat-box">
                <div class="edm-stat-number"><?php echo esc_html($stats['api_endpoint']); ?></div>
                <div class="edm-stat-label"><?php _e('Update Server', 'edm-efatura-premium'); ?></div>
            </div>
        </div>

        <?php if ($is_dismissed): ?>
        <!-- Dismissed Notice -->
        <div class="edm-update-card">
            <div class="edm-update-header">
                <span class="dashicons dashicons-clock edm-update-icon" style="color: #ffa500;"></span>
                <div>
                    <h2 class="edm-update-title"><?php _e('Update Notifications Paused', 'edm-efatura-premium'); ?></h2>
                    <p class="edm-update-subtitle">
                        <?php 
                        printf(
                            __('Update notifications are dismissed until %s', 'edm-efatura-premium'),
                            date_i18n(get_option('date_format') . ' ' . get_option('time_format'), $dismissed_until)
                        );
                        ?>
                    </p>
                </div>
            </div>
            <p><?php _e('You can still manually check for updates using the button below.', 'edm-efatura-premium'); ?></p>
        </div>
        <?php endif; ?>
        
        <!-- Main Update Status -->
        <div class="edm-update-card">
            <?php if ($status['status'] === 'update_available'): ?>
                <!-- Update Available -->
                <div class="edm-update-header">
                    <span class="dashicons dashicons-warning edm-update-icon available"></span>
                    <div>
                        <h2 class="edm-update-title">
                            <?php _e('Update Available!', 'edm-efatura-premium'); ?>
                            <?php if (isset($status['update_data'])): ?>
                                <?php if ($status['update_data']['is_security']): ?>
                                    <span class="edm-priority-badge edm-priority-security"><?php _e('Security Update', 'edm-efatura-premium'); ?></span>
                                <?php elseif ($status['update_data']['is_critical']): ?>
                                    <span class="edm-priority-badge edm-priority-critical"><?php _e('Critical Update', 'edm-efatura-premium'); ?></span>
                                <?php endif; ?>
                            <?php endif; ?>
                        </h2>
                        <p class="edm-update-subtitle"><?php echo esc_html($status['message']); ?></p>
                    </div>
                </div>
                
                <!-- Version Comparison -->
                <div class="edm-version-comparison">
                    <div class="edm-version-box edm-version-current">
                        <strong><?php _e('Current Version', 'edm-efatura-premium'); ?></strong><br>
                        <?php echo esc_html($status['current_version']); ?>
                    </div>
                    <div class="edm-version-box edm-version-latest">
                        <strong><?php _e('Latest Version', 'edm-efatura-premium'); ?></strong><br>
                        <?php echo esc_html($status['latest_version']); ?>
                    </div>
                </div>
                
                <?php if (isset($status['update_data']['changelog']) && !empty($status['update_data']['changelog'])): ?>
                <!-- Changelog -->
                <div class="edm-changelog">
                    <h3><?php _e('What\'s New:', 'edm-efatura-premium'); ?></h3>
                    <?php echo wp_kses_post(wpautop($status['update_data']['changelog'])); ?>
                </div>
                <?php endif; ?>
                
                <!-- Actions -->
                <div class="edm-update-actions">
                    <?php if (isset($status['update_data']['download_url'])): ?>
                        <a href="<?php echo esc_url($status['update_data']['download_url']); ?>" 
                           class="button button-primary" 
                           target="_blank">
                            <span class="dashicons dashicons-download"></span>
                            <?php _e('Download Update', 'edm-efatura-premium'); ?>
                        </a>
                    <?php endif; ?>
                    
                    <button type="button" id="edm-check-updates" class="button button-secondary">
                        <span class="dashicons dashicons-update"></span>
                        <?php _e('Check Again', 'edm-efatura-premium'); ?>
                    </button>
                    
                    <?php if (!$is_dismissed): ?>
                        <button type="button" id="edm-dismiss-update" class="button button-link">
                            <?php _e('Remind Me Later (1 Week)', 'edm-efatura-premium'); ?>
                        </button>
                    <?php endif; ?>
                </div>
                
                <?php if (isset($status['update_data'])): ?>
                <!-- Additional Info -->
                <div class="edm-last-check">
                    <strong><?php _e('Release Date:', 'edm-efatura-premium'); ?></strong> 
                    <?php echo esc_html(date_i18n(get_option('date_format'), strtotime($status['update_data']['release_date']))); ?>
                    <br>
                    <strong><?php _e('Requirements:', 'edm-efatura-premium'); ?></strong>
                    WordPress <?php echo esc_html($status['update_data']['min_wp_version']); ?>+, 
                    PHP <?php echo esc_html($status['update_data']['min_php_version']); ?>+
                </div>
                <?php endif; ?>
                
            <?php elseif ($status['status'] === 'up_to_date'): ?>
                <!-- Up to Date -->
                <div class="edm-update-header">
                    <span class="dashicons dashicons-yes-alt edm-update-icon up-to-date"></span>
                    <div>
                        <h2 class="edm-update-title"><?php _e('Plugin is Up to Date', 'edm-efatura-premium'); ?></h2>
                        <p class="edm-update-subtitle"><?php echo esc_html($status['message']); ?></p>
                    </div>
                </div>
                
                <p><?php _e('You are running the latest version of EDM E-Fatura Premium.', 'edm-efatura-premium'); ?></p>
                
                <div class="edm-version-comparison">
                    <div class="edm-version-box edm-version-latest">
                        <strong><?php _e('Current Version', 'edm-efatura-premium'); ?></strong><br>
                        <?php echo esc_html($status['current_version']); ?>
                    </div>
                </div>
                
                <div class="edm-update-actions">
                    <button type="button" id="edm-check-updates" class="button button-primary">
                        <span class="dashicons dashicons-update"></span>
                        <?php _e('Check for Updates', 'edm-efatura-premium'); ?>
                    </button>
                </div>
                
            <?php else: ?>
                <!-- Unknown Status -->
                <div class="edm-update-header">
                    <span class="dashicons dashicons-warning edm-update-icon" style="color: #ffa500;"></span>
                    <div>
                        <h2 class="edm-update-title"><?php _e('Update Status Unknown', 'edm-efatura-premium'); ?></h2>
                        <p class="edm-update-subtitle"><?php echo esc_html($status['message']); ?></p>
                    </div>
                </div>
                
                <p><?php _e('Unable to determine update status. This might be due to connectivity issues or server problems.', 'edm-efatura-premium'); ?></p>
                
                <div class="edm-update-actions">
                    <button type="button" id="edm-check-updates" class="button button-primary">
                        <span class="dashicons dashicons-update"></span>
                        <?php _e('Try Checking for Updates', 'edm-efatura-premium'); ?>
                    </button>
                </div>
            <?php endif; ?>
            
            <?php if ($stats['last_check']): ?>
            <div class="edm-last-check">
                <?php 
                printf(
                    __('Last checked: %s', 'edm-efatura-premium'),
                    human_time_diff($stats['last_check']) . ' ' . __('ago', 'edm-efatura-premium')
                );
                ?>
            </div>
            <?php endif; ?>
        </div>
        
        <!-- Help Section -->
        <div class="edm-update-card">
            <h3><?php _e('Update Help', 'edm-efatura-premium'); ?></h3>
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                <div>
                    <h4><?php _e('How to Update:', 'edm-efatura-premium'); ?></h4>
                    <ol>
                        <li><?php _e('Click "Download Update" button above', 'edm-efatura-premium'); ?></li>
                        <li><?php _e('Upload the ZIP file via Plugins → Add New → Upload', 'edm-efatura-premium'); ?></li>
                        <li><?php _e('Activate the updated plugin', 'edm-efatura-premium'); ?></li>
                        <li><?php _e('Check this page to confirm the update', 'edm-efatura-premium'); ?></li>
                    </ol>
                </div>
                <div>
                    <h4><?php _e('Automatic Checks:', 'edm-efatura-premium'); ?></h4>
                    <ul>
                        <li><?php _e('Updates are checked every 5 minutes automatically', 'edm-efatura-premium'); ?></li>
                        <li><?php _e('Notifications appear in admin header when available', 'edm-efatura-premium'); ?></li>
                        <li><?php _e('Critical and security updates are highlighted', 'edm-efatura-premium'); ?></li>
                        <li><?php _e('You can dismiss notifications for 1 week if needed', 'edm-efatura-premium'); ?></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>