<?php
/**
 * User Check page template
 *
 * @package EDM_Efatura_Premium
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get API instance
$settings = get_option('edm_efatura_premium_settings', array());
$api = null;

if (!empty($settings['api_url']) && !empty($settings['username']) && !empty($settings['password'])) {
    $edm_email = !empty($settings['edm_email']) ? $settings['edm_email'] : '';
    
    $api = new EDM_Efatura_Premium_API(
        $settings['api_url'],
        $settings['username'],
        $settings['password'],
        isset($settings['debug_mode']) && $settings['debug_mode'] === 'yes',
        $edm_email
    );
}
?>

<div class="wrap">
    <h1 class="wp-heading-inline"><?php echo esc_html__('User Check', 'edm-efatura-premium'); ?></h1>
    
    <hr class="wp-header-end">
    
    <div class="notice notice-info">
        <p><?php esc_html_e('Use this tool to check if a user is registered in the e-invoice system and retrieve their e-invoice alias.', 'edm-efatura-premium'); ?></p>
    </div>
    
    <div class="edm-user-check-form" style="background: #fff; padding: 20px; margin: 20px 0; border: 1px solid #ccd0d4;">
        <form id="edm-check-user-form">
            <div class="form-row">
                <label for="vkn"><strong><?php esc_html_e('VKN/TCKN', 'edm-efatura-premium'); ?></strong> <span class="required">*</span></label>
                <input type="text" id="vkn" name="vkn" required pattern="[0-9]{10,11}" placeholder="<?php esc_attr_e('Enter VKN (10 digits) or TCKN (11 digits)', 'edm-efatura-premium'); ?>" style="width: 300px; max-width: 100%;" />
                <p class="description"><?php esc_html_e('Tax ID number (VKN) or Turkish ID number (TCKN) to check.', 'edm-efatura-premium'); ?></p>
            </div>
            
            <div class="form-row" style="margin-top: 15px;">
                <button type="submit" class="button button-primary"><?php esc_html_e('Check User', 'edm-efatura-premium'); ?></button>
            </div>
        </form>
    </div>
    
    <div class="edm-result-box" style="display: none;"></div>
    
    <div class="edm-user-check-instructions" style="margin-top: 30px;">
        <h2><?php esc_html_e('User Check Instructions', 'edm-efatura-premium'); ?></h2>
        <p><?php esc_html_e('This tool allows you to check if a user is registered in the e-invoice system. If the user is registered, you can retrieve their e-invoice alias which is required when sending invoices.', 'edm-efatura-premium'); ?></p>
        
        <h3><?php esc_html_e('How it works', 'edm-efatura-premium'); ?></h3>
        <ol>
            <li><?php esc_html_e('Enter the VKN (Tax ID Number, 10 digits) for companies or TCKN (Turkish ID Number, 11 digits) for individuals.', 'edm-efatura-premium'); ?></li>
            <li><?php esc_html_e('Click the "Check User" button to query the e-invoice system.', 'edm-efatura-premium'); ?></li>
            <li><?php esc_html_e('If the user is registered, the system will display their details including their alias.', 'edm-efatura-premium'); ?></li>
            <li><?php esc_html_e('You can use this alias when sending invoices to this user.', 'edm-efatura-premium'); ?></li>
        </ol>
        
        <h3><?php esc_html_e('Common aliases format', 'edm-efatura-premium'); ?></h3>
        <p><?php esc_html_e('E-invoice aliases typically follow these formats:', 'edm-efatura-premium'); ?></p>
        <ul>
            <li><code>urn:mail:defaultpk@domain.com</code> - <?php esc_html_e('Standard email-based alias', 'edm-efatura-premium'); ?></li>
            <li><code>urn:mail:defaultgb@domain.com</code> - <?php esc_html_e('Special purpose alias', 'edm-efatura-premium'); ?></li>
            <li><code>urn:mail:pk@domain.com</code> - <?php esc_html_e('Alternative format', 'edm-efatura-premium'); ?></li>
        </ul>
    </div>
    
    <div class="edm-previous-checks" style="margin-top: 30px;">
        <h2><?php esc_html_e('Recent Checks', 'edm-efatura-premium'); ?></h2>
        <p><?php esc_html_e('Below are the results of your recent user checks:', 'edm-efatura-premium'); ?></p>
        
        <table class="wp-list-table widefat fixed striped" id="edm-recent-checks-table">
            <thead>
                <tr>
                    <th scope="col"><?php esc_html_e('VKN/TCKN', 'edm-efatura-premium'); ?></th>
                    <th scope="col"><?php esc_html_e('Title', 'edm-efatura-premium'); ?></th>
                    <th scope="col"><?php esc_html_e('Alias', 'edm-efatura-premium'); ?></th>
                    <th scope="col"><?php esc_html_e('Type', 'edm-efatura-premium'); ?></th>
                    <th scope="col"><?php esc_html_e('Actions', 'edm-efatura-premium'); ?></th>
                </tr>
            </thead>
            <tbody>
                <tr class="no-items">
                    <td colspan="5"><?php esc_html_e('No recent checks. Check a user to see results here.', 'edm-efatura-premium'); ?></td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<script>
jQuery(document).ready(function($) {
    // Store recent checks in browser local storage
    var recentChecks = [];
    
    try {
        recentChecks = JSON.parse(localStorage.getItem('edmRecentChecks')) || [];
    } catch (e) {
        recentChecks = [];
    }
    
    // Display recent checks
    function displayRecentChecks() {
        var $table = $('#edm-recent-checks-table tbody');
        
        if (recentChecks.length === 0) {
            $table.html('<tr class="no-items"><td colspan="5"><?php echo esc_js(__('No recent checks. Check a user to see results here.', 'edm-efatura-premium')); ?></td></tr>');
            return;
        }
        
        $table.empty();
        
        $.each(recentChecks, function(index, check) {
            if (!check || !check.identifier) {
                return; // Skip invalid entries
            }
            
            var html = '<tr>' +
                '<td>' + (check.identifier || '') + '</td>' +
                '<td>' + (check.title || '') + '</td>' +
                '<td>' + (check.alias || '') + '</td>' +
                '<td>' + (check.type || '') + '</td>' +
                '<td>' +
                '<button type="button" class="button button-small edm-use-recent" data-index="' + index + '"><?php echo esc_js(__('Use', 'edm-efatura-premium')); ?></button> ' +
                '<button type="button" class="button button-small edm-remove-recent" data-index="' + index + '"><?php echo esc_js(__('Remove', 'edm-efatura-premium')); ?></button>' +
                '</td>' +
                '</tr>';
            
            $table.append(html);
        });
    }
    
    // Add a new check to recent checks
    function addRecentCheck(user) {
        if (!user || !user.identifier) {
            return;
        }
        
        // Check if this user is already in the list
        var existingIndex = -1;
        
        $.each(recentChecks, function(index, check) {
            if (check && check.identifier === user.identifier) {
                existingIndex = index;
                return false;
            }
        });
        
        // If exists, remove it
        if (existingIndex !== -1) {
            recentChecks.splice(existingIndex, 1);
        }
        
        // Add to beginning of array
        recentChecks.unshift(user);
        
        // Limit to 10 items
        if (recentChecks.length > 10) {
            recentChecks.pop();
        }
        
        // Save to local storage
        try {
            localStorage.setItem('edmRecentChecks', JSON.stringify(recentChecks));
        } catch (e) {
            // localStorage save failed, continue silently
        }
        
        // Update display
        displayRecentChecks();
    }
    
    // Use a recent check
    $(document).on('click', '.edm-use-recent', function() {
        var index = $(this).data('index');
        
        if (recentChecks[index] && recentChecks[index].identifier) {
            $('#vkn').val(recentChecks[index].identifier);
            
            // Trigger submit
            $('#edm-check-user-form').submit();
        }
    });
    
    // Remove a recent check
    $(document).on('click', '.edm-remove-recent', function() {
        var index = $(this).data('index');
        
        if (index >= 0 && index < recentChecks.length) {
            recentChecks.splice(index, 1);
            
            // Save to local storage
            try {
                localStorage.setItem('edmRecentChecks', JSON.stringify(recentChecks));
            } catch (e) {
                // localStorage save failed, continue silently
            }
            
            // Update display
            displayRecentChecks();
        }
    });
    
    // Handle form submission
    $('#edm-check-user-form').on('submit', function(e) {
        e.preventDefault();
        
        var vkn = $('#vkn').val();
        
        if (!vkn) {
            alert('<?php echo esc_js(__('Please enter a VKN/TCKN number', 'edm-efatura-premium')); ?>');
            return;
        }
        
        $('.edm-result-box').html('<p><span class="spinner is-active"></span> <?php echo esc_js(__('Checking...', 'edm-efatura-premium')); ?></p>').show();
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'edm_check_user',
                nonce: edmEfaturaParams.nonce,
                vkn: vkn
            },
            success: function(response) {
                if (response.success) {
                    var user = response.data;
                    
                    if (!user || !user.identifier) {
                        $('.edm-result-box').html('<div class="notice notice-error"><p><?php echo esc_js(__('User not found in e-invoice system', 'edm-efatura-premium')); ?></p></div>');
                        return;
                    }
                    
                    var html = '<div class="edm-user-results" style="background: #fff; padding: 20px; border: 1px solid #ccd0d4;">';
                    html += '<h3><?php echo esc_js(__('User Details', 'edm-efatura-premium')); ?></h3>';
                    html += '<div class="edm-user-details">';
                    html += '<p><strong><?php echo esc_js(__('VKN/TCKN', 'edm-efatura-premium')); ?>:</strong> ' + (user.identifier || '') + '</p>';
                    html += '<p><strong><?php echo esc_js(__('Title', 'edm-efatura-premium')); ?>:</strong> ' + (user.title || '') + '</p>';
                    html += '<p><strong><?php echo esc_js(__('Alias', 'edm-efatura-premium')); ?>:</strong> ' + (user.alias || '') + '</p>';
                    html += '<p><strong><?php echo esc_js(__('Type', 'edm-efatura-premium')); ?>:</strong> ' + (user.type || '') + '</p>';
                    
                    if (user.unit) {
                        html += '<p><strong><?php echo esc_js(__('Unit', 'edm-efatura-premium')); ?>:</strong> ' + user.unit + '</p>';
                    }
                    
                    if (user.register_time) {
                        html += '<p><strong><?php echo esc_js(__('Register Time', 'edm-efatura-premium')); ?>:</strong> ' + user.register_time + '</p>';
                    }
                    
                    if (user.alias_creation_time) {
                        html += '<p><strong><?php echo esc_js(__('Alias Creation Time', 'edm-efatura-premium')); ?>:</strong> ' + user.alias_creation_time + '</p>';
                    }
                    
                    html += '</div>';
                    html += '</div>';
                    
                    $('.edm-result-box').html(html);
                    
                    // Add to recent checks
                    addRecentCheck(user);
                } else {
                    $('.edm-result-box').html('<div class="notice notice-error"><p>' + (response.data || '<?php echo esc_js(__('Unknown error occurred.', 'edm-efatura-premium')); ?>') + '</p></div>');
                }
            },
            error: function(xhr, status, error) {
                $('.edm-result-box').html('<div class="notice notice-error"><p><?php echo esc_js(__('Error', 'edm-efatura-premium')); ?>: ' + error + '</p></div>');
            }
        });
    });
    
    // Initialize recent checks display
    displayRecentChecks();
});
</script>