/**
 * EDM E-Fatura Premium Admin JS - Performance Optimized
 */
(function($) {
    'use strict';
    
    // Performance tracking
    var EDM_Performance = {
        startTime: performance.now(),
        ajaxQueue: [],
        isProcessing: false,
        retryAttempts: {},
        maxRetries: 3,
        
        // Debounce function for performance
        debounce: function(func, wait) {
            var timeout;
            return function executedFunction() {
                var context = this;
                var args = arguments;
                
                var later = function() {
                    timeout = null;
                    func.apply(context, args);
                };
                
                clearTimeout(timeout);
                timeout = setTimeout(later, wait);
            };
        },
        
        // Throttle function for performance
        throttle: function(func, limit) {
            var inThrottle;
            return function() {
                var args = arguments;
                var context = this;
                if (!inThrottle) {
                    func.apply(context, args);
                    inThrottle = true;
                    setTimeout(function() { inThrottle = false; }, limit);
                }
            };
        }
    };
    
    // Initialize functions when DOM is ready
    $(document).ready(function() {
        EDM_Performance.startTime = performance.now();
        
        
        // Clear old auto-check flags on page load
        clearOldAutoCheckFlags();
        
        initTabs();
        initLogToggles();
        initInvoiceActions();
        initFilters();
        initSettingsPage();
        initOrderListInvoiceButtons();
        
        // Log performance metrics
    });
    
    /**
     * Clear old auto-check flags from sessionStorage
     */
    function clearOldAutoCheckFlags() {
        // Only clear if we're on an order edit page
        if (window.location.href.indexOf('post.php') !== -1 || window.location.href.indexOf('action=edit') !== -1) {
            var keysToRemove = [];
            for (var i = 0; i < sessionStorage.length; i++) {
                var key = sessionStorage.key(i);
                if (key && key.startsWith('edm_auto_checked_')) {
                    keysToRemove.push(key);
                }
            }
            
            keysToRemove.forEach(function(key) {
                sessionStorage.removeItem(key);
            });
            
            if (keysToRemove.length > 0) {
            }
        }
    }
    
    // Additional check when window is fully loaded
    $(window).on('load', function() {
        // Try auto status check again after full page load
        setTimeout(function() {
            if ($('.edm-check-status').length > 0) {
                var uuid = $('.edm-check-status').first().data('uuid');
                if (uuid && !sessionStorage.getItem('edm_auto_checked_' + uuid)) {
                    sessionStorage.setItem('edm_auto_checked_' + uuid, 'true');
                    performAutoStatusCheck(uuid);
                }
            }
        }, 1000);
    });
    
    /**
     * Initialize tab functionality
     */
    function initTabs() {
        // If tabs already have proper links from PHP, no need for JS tab handling
        
        // Handle tab clicks for dynamic content
        $('.edm-tab').on('click', function(e) {
            if ($(this).attr('href').indexOf('#') === 0) {
                e.preventDefault();
                
                // Get tab ID
                var tabId = $(this).attr('href').replace('#', '');
                
                // Hide all sections
                $('.edm-section').hide();
                
                // Show selected section
                $('#edm-section-' + tabId).show();
                
                // Update active tab
                $('.edm-tab').removeClass('nav-tab-active');
                $(this).addClass('nav-tab-active');
            }
        });
    }
    
	/**
	 * Initialize invoice actions in order list
	 */
	function initOrderListInvoiceButtons() {
    // Generate invoice button in order list
    $(document).on('click', '.edm-generate-invoice-list', function(e) {
        e.preventDefault();
        
        var orderId = $(this).data('order-id');
        var button = $(this);
        var resultContainer = $('.edm-generate-result[data-order="' + orderId + '"]');
        
        if (!confirm(edmEfaturaParams.messages.confirmGenerate)) {
            return;
        }
        
        button.prop('disabled', true).text(edmEfaturaParams.messages.generating);
        resultContainer.show().html('<span class="spinner is-active" style="float:none;margin-left:0;"></span> ' + edmEfaturaParams.messages.loading);
        
        // Use optimized AJAX with retry mechanism
        performAjaxWithRetry({
            url: edmEfaturaParams.ajaxUrl,
            type: 'POST',
            data: {
                action: 'edm_generate_invoice_for_order',
                nonce: edmEfaturaParams.nonce,
                order_id: orderId
            },
            timeout: 30000, // 30 second timeout
            success: function(response) {
                button.prop('disabled', false).text(edmEfaturaParams.messages.generateInvoice || 'Generate Invoice');
                
                if (response.success) {
                    resultContainer.html('<span style="color: #46b450;">' + response.data + '</span>');
                    
                    // Refresh page after 1.5 seconds
                    setTimeout(function() {
                        window.location.reload();
                    }, 1500);
                    
                } else {
                    resultContainer.html('<span style="color: #dc3232;">' + response.data + '</span>');
                }
            },
            error: function(xhr, status, error) {
                button.prop('disabled', false).text(edmEfaturaParams.messages.generateInvoice || 'Generate Invoice');
                resultContainer.html('<span style="color: #dc3232;">' + error + '</span>');
            }
        }, 'generate_invoice_' + orderId);
    });
    
    // Generate PDF button in order list
    $(document).on('click', '.edm-generate-pdf', function(e) {
        if ($(this).closest('.column-edm_invoice').length > 0) {
            e.preventDefault();
            
            var uuid = $(this).data('uuid');
            var button = $(this);
            
            button.prop('disabled', true).text(edmEfaturaParams.messages.generating);
            
            $.ajax({
                url: edmEfaturaParams.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'edm_generate_pdf',
                    nonce: edmEfaturaParams.nonce,
                    uuid: uuid
                },
                success: function(response) {
                    if (response.success) {
                        // Success message
                        var tempDiv = $('<div class="notice notice-success is-dismissible"><p>' + response.data + '</p></div>')
                            .appendTo(button.closest('td'));
                        
                        // Refresh after 1.5 seconds
                        setTimeout(function() {
                            window.location.reload();
                        }, 500);
                    } else {
                        // Error message
                        var tempDiv = $('<div class="notice notice-error is-dismissible"><p>' + response.data + '</p></div>')
                            .appendTo(button.closest('td'));
                        
                        // Restore button
                        button.prop('disabled', false).text(edmEfaturaParams.messages.generatePdf || 'Generate PDF');
                        
                        // Auto-remove after 5 seconds
                        setTimeout(function() {
                            tempDiv.fadeOut(function() {
                                $(this).remove();
                            });
                        }, 5000);
                    }
                },
                error: function() {
                    button.prop('disabled', false).text(edmEfaturaParams.messages.generatePdf || 'Generate PDF');
                    
                    // Error message
                    var tempDiv = $('<div class="notice notice-error is-dismissible"><p>' + edmEfaturaParams.messages.error + '</p></div>')
                        .appendTo(button.closest('td'));
                    
                    // Auto-remove after 5 seconds
                    setTimeout(function() {
                        tempDiv.fadeOut(function() {
                            $(this).remove();
                        });
                    }, 5000);
                }
            });
        }
    });
}
    
    /**
     * Initialize log context toggles
     */
    function initLogToggles() {
		// Completely remove any previous event handlers
		$(document).off('click', '.edm-log-toggle');
		
		// Add new event handler with direct DOM manipulation
		$(document).on('click', '.edm-log-toggle', function() {
			// Get the log ID from data attribute
			var logId = $(this).data('log-id');
			var contextDiv = $('#log-context-' + logId);
			
			// Check if context is visible
			if (contextDiv.is(':visible')) {
				// Hide context
				contextDiv.hide();
				$(this).text(edmEfaturaParams.messages.showContext || 'Show Context');
			} else {
				// Show context
				contextDiv.show();
				$(this).text(edmEfaturaParams.messages.hideContext || 'Hide Context');
			}
		});
	}
    
    /**
     * Initialize invoice action buttons
     */
    function initInvoiceActions() {
    // Auto check invoice status on page load for order edit pages
    autoCheckInvoiceStatus();
    // Check status button
    $(document).on('click', '.edm-check-status', function(e) {
        e.preventDefault();
        
        var uuid = $(this).data('uuid');
        var $resultBox = $('.edm-result-box');
        var button = $(this);
        
        $resultBox.html('<p><span class="spinner is-active"></span> ' + (edmEfaturaParams.messages.loading || 'Loading...') + '</p>').show();
        button.prop('disabled', true).text(edmEfaturaParams.messages.loading || 'Loading...');
        
        $.ajax({
            url: edmEfaturaParams.ajaxUrl,
            type: 'POST',
            data: {
                action: 'edm_check_invoice_status',
                nonce: edmEfaturaParams.nonce,
                uuid: uuid
            },
            success: function(response) {
                button.prop('disabled', false).text(edmEfaturaParams.messages.checkStatus || 'Check Status');
                
                if (response.success) {
                    var html = '<div class="notice notice-success is-dismissible">';
                    html += '<p><strong>' + (edmEfaturaParams.messages.statusTitle || 'Invoice Status') + ':</strong> ';
                    html += response.data.status + ' - ' + response.data.description + '</p>';
                    html += '<button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>';
                    html += '</div>';
                    
                    $resultBox.html(html);
                    
                    // Refresh page after 2 seconds
                    setTimeout(function() {
                        location.reload();
                    }, 500);
                } else {
                    var html = '<div class="notice notice-error is-dismissible">';
                    html += '<p><strong>' + (edmEfaturaParams.messages.error || 'Error') + ':</strong> ' + response.data + '</p>';
                    html += '<button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>';
                    html += '</div>';
                    
                    $resultBox.html(html);
                }
            },
            error: function(xhr, status, error) {
                button.prop('disabled', false).text(edmEfaturaParams.messages.checkStatus || 'Check Status');
                
                var html = '<div class="notice notice-error is-dismissible">';
                html += '<p><strong>' + (edmEfaturaParams.messages.error || 'Error') + ':</strong> ' + error + '</p>';
                html += '<button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>';
                html += '</div>';
                
                $resultBox.html(html);
            }
        });
    });
    
    // Generate PDF button
    $(document).on('click', '.edm-generate-pdf', function(e) {
        e.preventDefault();
        
        var uuid = $(this).data('uuid');
        var $resultBox = $('.edm-result-box');
        var button = $(this);
        
        $resultBox.html('<p><span class="spinner is-active"></span> ' + (edmEfaturaParams.messages.loading || 'Loading...') + '</p>').show();
        button.prop('disabled', true).text(edmEfaturaParams.messages.loading || 'Loading...');
        
        $.ajax({
            url: edmEfaturaParams.ajaxUrl,
            type: 'POST',
            data: {
                action: 'edm_generate_pdf',
                nonce: edmEfaturaParams.nonce,
                uuid: uuid
            },
            success: function(response) {
                button.prop('disabled', false).text(edmEfaturaParams.messages.generatePdf || 'Generate PDF');
                
                if (response.success) {
                    var html = '<div class="notice notice-success is-dismissible">';
                    html += '<p>' + response.data + '</p>';
                    html += '<button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>';
                    html += '</div>';
                    
                    $resultBox.html(html);
                    
                    // Refresh page after 1.5 seconds
                    setTimeout(function() {
                        location.reload();
                    }, 500);
                } else {
                    var html = '<div class="notice notice-error is-dismissible">';
                    html += '<p><strong>' + (edmEfaturaParams.messages.error || 'Error') + ':</strong> ' + response.data + '</p>';
                    html += '<button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>';
                    html += '</div>';
                    
                    $resultBox.html(html);
                }
            },
            error: function(xhr, status, error) {
                button.prop('disabled', false).text(edmEfaturaParams.messages.generatePdf || 'Generate PDF');
                
                var html = '<div class="notice notice-error is-dismissible">';
                html += '<p><strong>' + (edmEfaturaParams.messages.error || 'Error') + ':</strong> ' + error + '</p>';
                html += '<button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>';
                html += '</div>';
                
                $resultBox.html(html);
            }
        });
    });
	// E-posta gönder butonu için
    $(document).on('click', '.edm-send-invoice-email', function(e) {
		e.preventDefault();
		
		var orderId = $(this).data('order-id');
		var uuid = $(this).data('uuid');
		var $resultBox = $('.edm-result-box');
		var button = $(this);
		
		if (!confirm(edmEfaturaParams.messages.confirmSendEmail || 'Are you sure you want to send invoice email to the customer?')) {
			return;
		}
		
		$resultBox.html('<p><span class="spinner is-active"></span> ' + (edmEfaturaParams.messages.sending || 'Sending...') + '</p>').show();
		button.prop('disabled', true).text(edmEfaturaParams.messages.sending || 'Sending...');
		
		$.ajax({
			url: edmEfaturaParams.ajaxUrl,
			type: 'POST',
			data: {
				action: 'edm_send_invoice_email',
				nonce: edmEfaturaParams.nonce,
				order_id: orderId,
				uuid: uuid
			},
			success: function(response) {
				button.prop('disabled', false).text(edmEfaturaParams.messages.sendEmail || 'Send Invoice Email');
				
				if (response.success) {
					var html = '<div class="notice notice-success is-dismissible">';
					html += '<p>' + response.data + '</p>';
					html += '<button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>';
					html += '</div>';
					
					$resultBox.html(html);
					
					// Refresh page after 1.5 seconds
					setTimeout(function() {
						location.reload();
					}, 500);
				} else {
					var html = '<div class="notice notice-error is-dismissible">';
					html += '<p><strong>' + (edmEfaturaParams.messages.error || 'Error') + ':</strong> ' + response.data + '</p>';
					html += '<button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>';
					html += '</div>';
					
					$resultBox.html(html);
				}
			},
			error: function(xhr, status, error) {
				button.prop('disabled', false).text(edmEfaturaParams.messages.sendEmail || 'Send Invoice Email');
				
				var html = '<div class="notice notice-error is-dismissible">';
				html += '<p><strong>' + (edmEfaturaParams.messages.error || 'Error') + ':</strong> ' + error + '</p>';
				html += '<button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>';
				html += '</div>';
				
				$resultBox.html(html);
			}
		});
	});
    // Generate new invoice button
    $(document).on('click', '.edm-generate-invoice', function(e) {
        e.preventDefault();
        
        var orderId = $(this).data('order-id');
        var $resultBox = $('.edm-result-box');
        var button = $(this);
        
        if (!confirm(edmEfaturaParams.messages.confirmGenerate || 'Are you sure you want to generate a new invoice for this order?')) {
            return;
        }
        
        $resultBox.html('<p><span class="spinner is-active"></span> ' + (edmEfaturaParams.messages.loading || 'Loading...') + '</p>').show();
        button.prop('disabled', true).text(edmEfaturaParams.messages.generating || 'Generating...');
        
        // Collect form data if form exists
        var ajaxData = {
            action: 'edm_generate_invoice_for_order',
            nonce: edmEfaturaParams.nonce,
            order_id: orderId
        };
        
        // Check if invoice form exists and collect data
        var invoiceForm = $('.edm-invoice-form');
        if (invoiceForm.length > 0) {
            // Get invoice type
            var invoiceType = $('input[name="edm_invoice_type"]:checked').val();
            ajaxData.invoice_type = invoiceType;
            
            // Get invoice profile
            var invoiceProfile = $('select[name="edm_invoice_profile"]').val();
            if (invoiceProfile) {
                ajaxData.invoice_profile = invoiceProfile;
            }
            
            // Get invoice type code
            var invoiceTypeCode = $('select[name="edm_invoice_type_code"]').val();
            if (invoiceTypeCode) {
                ajaxData.invoice_type_code = invoiceTypeCode;
            }
            
            // Get exception code if applicable
            var exceptionCode = $('select[name="edm_exception_code"]').val();
            if (exceptionCode) {
                ajaxData.exception_code = exceptionCode;
            }
            
            // Get tax rate if applicable
            var taxRate = $('input[name="edm_tax_rate"]').val();
            if (taxRate !== undefined && taxRate !== null && taxRate !== '') {
                ajaxData.tax_rate = parseFloat(taxRate);
            }
            
            // Get corporate fields if corporate type is selected
            if (invoiceType === 'corporate') {
                var companyName = $('input[name="edm_company_name"]').val();
                var taxNumber = $('input[name="edm_tax_number"]').val();
                var taxOffice = $('input[name="edm_tax_office"]').val();
                
                if (companyName) ajaxData.company_name = companyName;
                if (taxNumber) ajaxData.tax_number = taxNumber;
                if (taxOffice) ajaxData.tax_office = taxOffice;
            }
            
        } else {
        }
        
        $.ajax({
            url: edmEfaturaParams.ajaxUrl,
            type: 'POST',
            data: ajaxData,
            success: function(response) {
                button.prop('disabled', false).text(edmEfaturaParams.messages.generateInvoice || 'Generate New Invoice');
                
                if (response.success) {
                    var html = '<div class="notice notice-success is-dismissible">';
                    html += '<p>' + response.data + '</p>';
                    html += '<button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>';
                    html += '</div>';
                    
                    $resultBox.html(html);
                    
                    // Refresh page after 1.5 seconds
                    setTimeout(function() {
                        location.reload();
                    }, 500);
                } else {
                    var html = '<div class="notice notice-error is-dismissible">';
                    html += '<p><strong>' + (edmEfaturaParams.messages.error || 'Error') + ':</strong> ' + response.data + '</p>';
                    html += '<button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>';
                    html += '</div>';
                    
                    $resultBox.html(html);
                }
            },
            error: function(xhr, status, error) {
                button.prop('disabled', false).text(edmEfaturaParams.messages.generateInvoice || 'Generate New Invoice');
                
                var html = '<div class="notice notice-error is-dismissible">';
                html += '<p><strong>' + (edmEfaturaParams.messages.error || 'Error') + ':</strong> ' + error + '</p>';
                html += '<button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>';
                html += '</div>';
                
                $resultBox.html(html);
            }
        });
    });
    
    // Cancel invoice button - multiple selectors for safety
    $(document).on('click', '.edm-cancel-invoice, button[data-uuid].button-secondary, button:contains("Faturayı İptal Et")', function(e) {
        e.preventDefault();
        
        var uuid = $(this).data('uuid');
        var $resultBox = $('.edm-result-box');
        var button = $(this);
        
        if (!confirm('Bu faturayı iptal etmek istediğinizden emin misiniz?')) {
            return;
        }
        
        $resultBox.html('<p><span class="spinner is-active"></span> İptal ediliyor...</p>').show();
        button.prop('disabled', true).text('İptal ediliyor...');
        
        // Check if edmEfaturaParams is available
        if (typeof edmEfaturaParams === 'undefined') {
            alert('Script yükleme hatası. Sayfayı yenileyin.');
            return;
        }
        
        $.ajax({
            url: edmEfaturaParams.ajaxUrl,
            type: 'POST',
            data: {
                action: 'edm_cancel_invoice',
                nonce: edmEfaturaParams.nonce,
                uuid: uuid
            },
            success: function(response) {
                button.prop('disabled', false).text('Faturayı İptal Et');
                
                if (response.success) {
                    var html = '<div class="notice notice-success is-dismissible">';
                    html += '<p>' + response.data + '</p>';
                    html += '<button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>';
                    html += '</div>';
                    
                    $resultBox.html(html);
                    
                    // Refresh page after 1.5 seconds
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    var html = '<div class="notice notice-error is-dismissible">';
                    html += '<p><strong>' + (edmEfaturaParams.messages.error || 'Error') + ':</strong> ' + response.data + '</p>';
                    html += '<button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>';
                    html += '</div>';
                    
                    $resultBox.html(html);
                }
            },
            error: function(xhr, status, error) {
                button.prop('disabled', false).text('Faturayı İptal Et');
                
                var html = '<div class="notice notice-error is-dismissible">';
                html += '<p><strong>' + (edmEfaturaParams.messages.error || 'Error') + ':</strong> ' + error + '</p>';
                html += '<button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>';
                html += '</div>';
                
                $resultBox.html(html);
            }
        });
    });
    
    
    // Corporate invoice generation (with TEMELFATURA)
    $(document).on('click', '.edm-generate-corporate-invoice', function(e) {
        e.preventDefault();
        
        var orderId = $(this).data('order-id');
        var $resultBox = $('.edm-result-box');
        var button = $(this);
        
        // Check if edmEfaturaParams is available
        if (typeof edmEfaturaParams === 'undefined' || !edmEfaturaParams.ajaxUrl) {
            alert('Script yükleme hatası. Sayfayı yenileyin.');
            return;
        }
        
        // Get company form data
        var companyName = $('#edm_company_name').val();
        var taxNumber = $('#edm_tax_number').val();
        var taxOffice = $('#edm_tax_office').val();
        var gibEmail = $('#edm_gib_email').val();
        var companyAddress = $('#edm_company_address').val();
        var companyCountry = $('#edm_company_country').val();
        
        // Validate required fields
        if (!companyName || !taxNumber || !taxOffice || !gibEmail || !companyAddress) {
            alert('Lütfen tüm zorunlu alanları doldurun (Firma Adı, Vergi Numarası, Vergi Dairesi, GİB E-posta, Şirket Adresi).');
            return;
        }
        
        // Clean GIB email - remove urn:mail prefix if user entered it
        gibEmail = gibEmail.replace(/^urn:mail:/, '');
        
        // GIB email format validation
        var gibEmailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (!gibEmailRegex.test(gibEmail)) {
            alert('Lütfen geçerli bir e-posta adresi girin.');
            return;
        }
        
        if (!confirm('Firmaya fatura oluşturmak istediğinizden emin misiniz?')) {
            return;
        }
        
        $resultBox.html('<p><span class="spinner is-active"></span> Firma faturası oluşturuluyor...</p>').show();
        button.prop('disabled', true).text('Oluşturuluyor...');
        
        $.ajax({
            url: edmEfaturaParams.ajaxUrl,
            type: 'POST',
            data: {
                action: 'edm_generate_invoice_for_order',
                nonce: edmEfaturaParams.nonce,
                order_id: orderId,
                invoice_type: 'corporate',
                invoice_profile: 'TEMELFATURA',
                company_name: companyName,
                tax_number: taxNumber,
                tax_office: taxOffice,
                gib_email: gibEmail,
                company_address: companyAddress,
                company_country: companyCountry
            },
            success: function(response) {
                button.prop('disabled', false).text('Firma Faturası Oluştur');
                
                if (response.success) {
                    var html = '<div class="notice notice-success is-dismissible">';
                    html += '<p>' + response.data + '</p>';
                    html += '<button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>';
                    html += '</div>';
                    
                    $resultBox.html(html);
                    
                    // Refresh page after 1.5 seconds
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    var html = '<div class="notice notice-error is-dismissible">';
                    html += '<p><strong>Hata:</strong> ' + response.data + '</p>';
                    html += '<button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>';
                    html += '</div>';
                    
                    $resultBox.html(html);
                }
            },
            error: function(xhr, status, error) {
                button.prop('disabled', false).text('Firma Faturası Oluştur');
                
                var html = '<div class="notice notice-error is-dismissible">';
                html += '<p><strong>Hata:</strong> ' + error + '</p>';
                html += '<button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>';
                html += '</div>';
                
                $resultBox.html(html);
            }
        });
    });
    
    // Add notice dismiss handler
    $(document).on('click', '.notice-dismiss', function() {
        $(this).closest('.notice').fadeOut();
    });
}
    
    /**
     * Initialize filter functionality
     */
    function initFilters() {
        // Date range picker if available
        if ($.fn.datepicker && $('.edm-date-range-picker').length) {
            $('.edm-date-range-picker').datepicker({
                dateFormat: 'yy-mm-dd',
                changeMonth: true,
                changeYear: true
            });
        }
        
        // Clean logs button
        $(document).on('click', '#edm-clean-logs', function(e) {
            e.preventDefault();
            
            if (!confirm(edmEfaturaParams.messages.confirmClean || 'Are you sure you want to clean old logs?')) {
                return;
            }
            
            var days = $('#days').val() || $('#log_retention').val() || 30;
            var $resultBox = $('.edm-result-box');
            
            $resultBox.html('<p><span class="spinner is-active"></span> ' + (edmEfaturaParams.messages.loading || 'Loading...') + '</p>').show();
            
            $.ajax({
                url: edmEfaturaParams.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'edm_clean_logs',
                    nonce: edmEfaturaParams.nonce,
                    days: days
                },
                success: function(response) {
                    if (response.success) {
                        $resultBox.html('<p class="edm-result-success">' + response.data.message + '</p>');
                        
                        // Refresh page after 2 seconds
                        setTimeout(function() {
                            window.location.reload();
                        }, 500);
                    } else {
                        $resultBox.html('<p class="edm-result-error">' + response.data + '</p>');
                    }
                },
                error: function(xhr, status, error) {
                    $resultBox.html('<p class="edm-result-error">' + (edmEfaturaParams.messages.error || 'Error') + ': ' + error + '</p>');
                }
            });
        });
    }
    
    /**
     * Initialize settings page functionality
     */
    function initSettingsPage() {
		// Show conditional fields based on invoice type
		$('#invoice_type').on('change', function() {
			var type = $(this).val();
			
			if (type === 'ISTISNA') {
				$('#invoice_exception_code_row').show();
				$('.edm-settings-wrap label[for="invoice_exception_code"] .required').show();
				$('#default_tax_rate_row').hide();
				$('.edm-settings-wrap label[for="default_tax_rate"] .required').hide();
			} else if (type === 'SATIS') {
				$('#invoice_exception_code_row').hide();
				$('.edm-settings-wrap label[for="invoice_exception_code"] .required').hide();
				$('#default_tax_rate_row').show();
				$('.edm-settings-wrap label[for="default_tax_rate"] .required').show();
			} else {
				$('#invoice_exception_code_row').hide();
				$('.edm-settings-wrap label[for="invoice_exception_code"] .required').hide();
				$('#default_tax_rate_row').hide();
				$('.edm-settings-wrap label[for="default_tax_rate"] .required').hide();
			}
		}).trigger('change');
		
		// WooCommerce enabled checkbox
		$('#woocommerce_enabled').on('change', function() {
			if ($(this).is(':checked')) {
				$('#auto_generate_invoice, #attach_pdf_to_email, #order_status_for_invoice, #invoice_delay_days').closest('tr').show();
			} else {
				$('#auto_generate_invoice, #attach_pdf_to_email, #order_status_for_invoice, #invoice_delay_days').closest('tr').hide();
			}
		}).trigger('change');
	}
    
    // Performance-optimized AJAX function with retry mechanism
    function performAjaxWithRetry(options, requestKey) {
        var retryKey = requestKey || 'generic_request';
        
        // Initialize retry count
        if (!EDM_Performance.retryAttempts[retryKey]) {
            EDM_Performance.retryAttempts[retryKey] = 0;
        }
        
        // Add to queue if processing
        if (EDM_Performance.isProcessing) {
            EDM_Performance.ajaxQueue.push({options: options, key: retryKey});
            return;
        }
        
        EDM_Performance.isProcessing = true;
        
        var originalSuccess = options.success || function() {};
        var originalError = options.error || function() {};
        
        options.success = function(response) {
            EDM_Performance.retryAttempts[retryKey] = 0; // Reset on success
            EDM_Performance.isProcessing = false;
            processAjaxQueue();
            originalSuccess(response);
        };
        
        options.error = function(xhr, status, error) {
            EDM_Performance.isProcessing = false;
            
            // Retry logic
            if (EDM_Performance.retryAttempts[retryKey] < EDM_Performance.maxRetries && 
                (status === 'timeout' || xhr.status >= 500)) {
                
                EDM_Performance.retryAttempts[retryKey]++;
                
                setTimeout(function() {
                    performAjaxWithRetry(options, retryKey);
                }, 1000 * EDM_Performance.retryAttempts[retryKey]); // Exponential backoff
                
                return;
            }
            
            // Max retries reached or non-retryable error
            EDM_Performance.retryAttempts[retryKey] = 0;
            processAjaxQueue();
            originalError(xhr, status, error);
        };
        
        $.ajax(options);
    }
    
    // Process AJAX queue
    function processAjaxQueue() {
        if (EDM_Performance.ajaxQueue.length > 0 && !EDM_Performance.isProcessing) {
            var nextRequest = EDM_Performance.ajaxQueue.shift();
            performAjaxWithRetry(nextRequest.options, nextRequest.key);
        }
    }
    
    // Update invoice status without full page reload
    function updateInvoiceStatus(orderId, message) {
        // Update specific elements instead of reloading entire page
        var statusElements = $('.edm-invoice-status[data-order="' + orderId + '"]');
        if (statusElements.length > 0) {
            statusElements.html('<span style="color: #46b450;">✓ ' + message + '</span>');
        }
        
        // Show success notification
        showNotification(message, 'success');
        
        // Optional: Update other related UI elements
        updateInvoiceButtons(orderId);
    }
    
    // Show notification instead of page reload
    function showNotification(message, type) {
        var notification = $('<div class="edm-notification edm-notification-' + type + '">' + message + '</div>');
        
        $('body').append(notification);
        
        notification.fadeIn(300).delay(3000).fadeOut(300, function() {
            $(this).remove();
        });
    }
    
    // Update invoice-related buttons after operations
    function updateInvoiceButtons(orderId) {
        var buttonContainer = $('.edm-invoice-actions[data-order="' + orderId + '"]');
        if (buttonContainer.length > 0) {
            // Add new action buttons or update existing ones
            if (!buttonContainer.find('.edm-download-pdf').length) {
                buttonContainer.append('<button type="button" class="button edm-download-pdf" data-order="' + orderId + '">Download PDF</button>');
            }
        }
    }
    
    /**
     * Auto check invoice status on page load for order edit pages
     */
    function autoCheckInvoiceStatus() {
        // Try multiple times to ensure elements are loaded
        var attempts = 0;
        var maxAttempts = 10;
        
        function tryAutoCheck() {
            attempts++;
            
            // Only run on order edit pages that have invoice check button
            var statusButtons = $('.edm-check-status');
            
            if (statusButtons.length > 0) {
                // Get UUID from the check status button
                var uuid = statusButtons.first().data('uuid');
                
                var alreadyChecked = sessionStorage.getItem('edm_auto_checked_' + uuid);
                
                // Only proceed if we have a UUID and haven't auto-checked yet
                if (uuid && !alreadyChecked) {
                    // Mark as auto-checked to prevent repeated checks
                    sessionStorage.setItem('edm_auto_checked_' + uuid, 'true');
                    
                    
                    // Perform the check immediately
                    performAutoStatusCheck(uuid);
                    return;
                } else {
                }
            }
            
            // If elements not found and we haven't reached max attempts, try again
            if (attempts < maxAttempts) {
                setTimeout(tryAutoCheck, 500);
            } else {
            }
        }
        
        // Start checking after a small delay
        setTimeout(tryAutoCheck, 500);
    }
    
    /**
     * Perform automatic status check
     */
    function performAutoStatusCheck(uuid) {
        
        $.ajax({
            url: edmEfaturaParams.ajaxUrl,
            type: 'POST',
            data: {
                action: 'edm_check_invoice_status',
                nonce: edmEfaturaParams.nonce,
                uuid: uuid
            },
            success: function(response) {
                if (response.success) {
                    // Update the status display silently
                    updateStatusDisplay(response.data);
                } else {
                }
            },
            error: function(xhr, status, error) {
            }
        });
    }
    
    /**
     * Update status display without showing notification
     */
    function updateStatusDisplay(statusData) {
        
        // Find the correct status elements (.edm-status class)
        var $statusElements = $('.edm-status');
        
        if ($statusElements.length > 0) {
            $statusElements.each(function() {
                var $statusElement = $(this);
                
                // Update status text if the element exists
                if (statusData.status && statusData.description) {
                    var statusText = statusData.status + ' - ' + statusData.description;
                    $statusElement.text(statusText);
                    
                    // Remove existing status classes
                    $statusElement.removeClass('edm-status-pending edm-status-processing edm-status-completed edm-status-error edm-status-success');
                    
                    // Add appropriate status class based on status
                    var statusLower = statusData.status.toLowerCase();
                    if (statusLower.indexOf('processing') !== -1) {
                        $statusElement.addClass('edm-status-processing');
                    } else if (statusLower.indexOf('succeed') !== -1 || statusLower.indexOf('success') !== -1) {
                        $statusElement.addClass('edm-status-success');
                    } else if (statusLower.indexOf('error') !== -1 || statusLower.indexOf('failed') !== -1) {
                        $statusElement.addClass('edm-status-error');
                    } else {
                        $statusElement.addClass('edm-status-pending');
                    }
                }
            });
            
            // No automatic page refresh - just update the display
        } else {
        }
    }
    
})(jQuery);