<?php
/**
 * EDM E-Fatura Premium Loader Class
 *
 * @package EDM_Efatura_Premium
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class for registering and executing hooks
 */
class EDM_Efatura_Premium_Loader {
    /**
     * Array of actions
     *
     * @var array
     */
    protected $actions;

    /**
     * Array of filters
     *
     * @var array
     */
    protected $filters;

    /**
     * Constructor
     */
    public function __construct() {
        $this->actions = array();
        $this->filters = array();
    }

    /**
     * Add an action to the collection
     *
     * @param string $hook          The name of the WordPress action
     * @param object $component     A reference to the component object
     * @param string $callback      The name of the function in the component
     * @param int    $priority      Optional. The priority of the action. Default 10
     * @param int    $accepted_args Optional. Accepted args. Default 1
     */
    public function add_action($hook, $component, $callback, $priority = 10, $accepted_args = 1) {
        $this->actions = $this->add($this->actions, $hook, $component, $callback, $priority, $accepted_args);
    }

    /**
     * Add a filter to the collection
     *
     * @param string $hook          The name of the WordPress filter
     * @param object $component     A reference to the component object
     * @param string $callback      The name of the function in the component
     * @param int    $priority      Optional. The priority of the filter. Default 10
     * @param int    $accepted_args Optional. Accepted args. Default 1
     */
    public function add_filter($hook, $component, $callback, $priority = 10, $accepted_args = 1) {
        $this->filters = $this->add($this->filters, $hook, $component, $callback, $priority, $accepted_args);
    }

    /**
     * Helper function to register actions and filters
     *
     * @param array  $hooks         The collection of hooks to register with WordPress
     * @param string $hook          The name of the WordPress hook
     * @param object $component     A reference to the component object
     * @param string $callback      The name of the function in the component
     * @param int    $priority      The priority of the hook
     * @param int    $accepted_args The number of arguments the function accepts
     * @return array The collection of actions and filters registered with WordPress
     */
    private function add($hooks, $hook, $component, $callback, $priority, $accepted_args) {
        $hooks[] = array(
            'hook'          => $hook,
            'component'     => $component,
            'callback'      => $callback,
            'priority'      => $priority,
            'accepted_args' => $accepted_args
        );

        return $hooks;
    }

    /**
     * Register all defined actions and filters with WordPress
     */
    public function run() {
        foreach ($this->filters as $hook) {
            add_filter(
                $hook['hook'],
                array($hook['component'], $hook['callback']),
                $hook['priority'],
                $hook['accepted_args']
            );
        }

        foreach ($this->actions as $hook) {
            add_action(
                $hook['hook'],
                array($hook['component'], $hook['callback']),
                $hook['priority'],
                $hook['accepted_args']
            );
        }
    }
}