<?php
/**
 * Customer E-Invoice email
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/customer-edm-invoice.php.
 *
 * @version 1.0.0
 */

defined('ABSPATH') || exit;

/*
 * @hooked WC_Emails::email_header() Output the email header
 */
do_action('woocommerce_email_header', $email_heading, $email); ?>

<?php /* translators: %s: Customer first name */ ?>
<p><?php printf(esc_html__('Hi %s,', 'edm-efatura-premium'), esc_html($order->get_billing_first_name())); ?></p>
<p><?php printf(esc_html__('Your e-invoice for order #%s has been generated and is available for download.', 'edm-efatura-premium'), esc_html($order->get_order_number())); ?></p>

<?php if (!empty($invoice['invoice_id'])): ?>
<h2><?php esc_html_e('Invoice Details', 'edm-efatura-premium'); ?></h2>
<ul>
    <li><strong><?php esc_html_e('Invoice ID:', 'edm-efatura-premium'); ?></strong> <?php echo esc_html($invoice['invoice_id']); ?></li>
    <li><strong><?php esc_html_e('Date:', 'edm-efatura-premium'); ?></strong> <?php echo esc_html(date_i18n(get_option('date_format'), strtotime($invoice['created_at']))); ?></li>
    <li><strong><?php esc_html_e('Status:', 'edm-efatura-premium'); ?></strong> <?php echo esc_html($invoice['status']); ?></li>
</ul>
<?php endif; ?>

<?php
/*
 * @hooked WC_Emails::order_details() Shows the order details table.
 * @hooked WC_Emails::order_schema_markup() Adds Schema.org markup.
 */
do_action('woocommerce_email_order_details', $order, $sent_to_admin, $plain_text, $email);

/*
 * @hooked WC_Emails::order_meta() Shows order meta data.
 */
do_action('woocommerce_email_order_meta', $order, $sent_to_admin, $plain_text, $email);

/*
 * @hooked WC_Emails::customer_details() Shows customer details
 */
do_action('woocommerce_email_customer_details', $order, $sent_to_admin, $plain_text, $email);

/**
 * Show user-defined additional content - this is set in each email's settings.
 */
if ($additional_content) {
    echo wp_kses_post(wpautop(wptexturize($additional_content)));
}

/*
 * @hooked WC_Emails::email_footer() Output the email footer
 */
do_action('woocommerce_email_footer', $email);