<?php
/**
 * Customer E-Invoice email (plain text)
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/plain/customer-edm-invoice.php.
 *
 * @version 1.0.0
 */

defined('ABSPATH') || exit;

echo "= " . esc_html($email_heading) . " =\n\n";

/* translators: %s: Customer first name */
echo sprintf(esc_html__('Hi %s,', 'edm-efatura-premium'), esc_html($order->get_billing_first_name())) . "\n\n";
echo sprintf(esc_html__('Your e-invoice for order #%s has been generated and is available for download.', 'edm-efatura-premium'), esc_html($order->get_order_number())) . "\n\n";

if (!empty($invoice['invoice_id'])) {
    echo "= " . esc_html__('Invoice Details', 'edm-efatura-premium') . " =\n\n";
    echo esc_html__('Invoice ID:', 'edm-efatura-premium') . ' ' . esc_html($invoice['invoice_id']) . "\n";
    echo esc_html__('Date:', 'edm-efatura-premium') . ' ' . esc_html(date_i18n(get_option('date_format'), strtotime($invoice['created_at']))) . "\n";
    echo esc_html__('Status:', 'edm-efatura-premium') . ' ' . esc_html($invoice['status']) . "\n\n";
}

/*
 * @hooked WC_Emails::order_details() Shows the order details table.
 */
do_action('woocommerce_email_order_details', $order, $sent_to_admin, $plain_text, $email);

/*
 * @hooked WC_Emails::order_meta() Shows order meta data.
 */
do_action('woocommerce_email_order_meta', $order, $sent_to_admin, $plain_text, $email);

/*
 * @hooked WC_Emails::customer_details() Shows customer details
 */
do_action('woocommerce_email_customer_details', $order, $sent_to_admin, $plain_text, $email);

echo "\n=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n\n";

echo esc_html(wp_strip_all_tags($additional_content));

echo "\n=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n\n";

echo esc_html__('Thanks for shopping with us.', 'edm-efatura-premium') . "\n\n";

echo esc_html(wp_strip_all_tags(get_bloginfo('name')));